using System;
using System.Web;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class STD_REFERRALSTSDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public STD_REFERRALSTSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public STD_REFERRALSTS GetItemByCode(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string CODE)
        {
            STD_REFERRALSTS objReturn = null;

            SqlConnection sConn = null;
            SqlCommand sCmd = null;
            SqlDataAdapter sAdapter = null;
            DataSet objTemp = null;

            try
            {
                sConn = new SqlConnection(SqlConnectionString);

                sConn.Open();

                sCmd = new SqlCommand("CRS.usp_STD_REFERRALSTS_getitemByCode", sConn);
                sCmd.CommandTimeout = SqlCommandTimeout;
                sCmd.CommandType = CommandType.StoredProcedure;
                sCmd.Parameters.AddWithValue("@CURRENT_USER", CURRENT_USER);
                sCmd.Parameters.AddWithValue("@CURRENT_REGISTRY_ID", CURRENT_REGISTRY_ID);
                sCmd.Parameters.AddWithValue("@CODE", CODE);

                objTemp = new DataSet();
                sAdapter = new SqlDataAdapter(sCmd);

                LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                sAdapter.Fill(objTemp);
                LogManager.LogTiming(logDetails);
                CheckDataSet(objTemp);

                if (objTemp != null && objTemp.Tables.Count > 0 && objTemp.Tables[0].Rows.Count > 0)
                {
                    objReturn = ParseReader(objTemp.Tables[0].Rows[0]);
                }

                sConn.Close();
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }
            finally
            {
                if (sAdapter != null)
                {
                    sAdapter.Dispose();
                    sAdapter = null;
                }
                if (sCmd != null)
                {
                    sCmd.Dispose();
                    sCmd = null;
                }
                if (sConn != null)
                {
                    if (sConn.State != ConnectionState.Closed) { sConn.Close(); }
                    sConn.Dispose();
                    sConn = null;
                }
            }

            return objReturn;
        }

        public STD_REFERRALSTS ParseReader(DataRow row)
        {
            STD_REFERRALSTS objReturn = new STD_REFERRALSTS
            {
                CODE = (string)GetNullableObject(row.Field<object>("CODE")),
                CREATED = (DateTime)GetNullableObject(row.Field<object>("CREATED")),
                CREATEDBY = (string)GetNullableObject(row.Field<object>("CREATEDBY")),
                DESCRIPTION_TEXT = (string)GetNullableObject(row.Field<object>("DESCRIPTION_TEXT")),
                ID = (Int32)GetNullableObject(row.Field<object>("ID")),
                INACTIVE_DATE = (DateTime?)GetNullableObject(row.Field<object>("INACTIVE_DATE")),
                INACTIVE_FLAG = (bool)GetNullableObject(row.Field<object>("INACTIVE_FLAG")),
                NAME = (string)GetNullableObject(row.Field<object>("NAME")),
                SORT_ORDER = (Int32)GetNullableObject(row.Field<object>("SORT_ORDER")),
                STD_REGISTRY_ID = (Int32?)GetNullableObject(row.Field<object>("STD_REGISTRY_ID")),
                UPDATED = (DateTime)GetNullableObject(row.Field<object>("UPDATED")),
                UPDATEDBY = (string)GetNullableObject(row.Field<object>("UPDATEDBY"))
            };

            return objReturn;
        }

        public STD_REFERRALSTS ParseReaderCustom(DataRow row)
        {
            STD_REFERRALSTS objReturn = new STD_REFERRALSTS
            {
                CODE = (string)GetNullableObject(row.Field<object>("STD_REFERRALSTS_CODE")),
                CREATED = (DateTime)GetNullableObject(row.Field<object>("STD_REFERRALSTS_CREATED")),
                CREATEDBY = (string)GetNullableObject(row.Field<object>("STD_REFERRALSTS_CREATEDBY")),
                DESCRIPTION_TEXT = (string)GetNullableObject(row.Field<object>("STD_REFERRALSTS_DESCRIPTION_TEXT")),
                ID = (Int32)GetNullableObject(row.Field<object>("STD_REFERRALSTS_ID")),
                INACTIVE_DATE = (DateTime?)GetNullableObject(row.Field<object>("STD_REFERRALSTS_INACTIVE_DATE")),
                INACTIVE_FLAG = (bool)GetNullableObject(row.Field<object>("STD_REFERRALSTS_INACTIVE_FLAG")),
                NAME = (string)GetNullableObject(row.Field<object>("STD_REFERRALSTS_NAME")),
                SORT_ORDER = (Int32)GetNullableObject(row.Field<object>("STD_REFERRALSTS_SORT_ORDER")),
                STD_REGISTRY_ID = (Int32?)GetNullableObject(row.Field<object>("STD_REFERRALSTS_STD_REGISTRY_ID")),
                UPDATED = (DateTime)GetNullableObject(row.Field<object>("STD_REFERRALSTS_UPDATED")),
                UPDATEDBY = (string)GetNullableObject(row.Field<object>("STD_REFERRALSTS_UPDATEDBY"))
            };

            return objReturn;
        }

        #endregion
    }
}
